class PhysicalPoint {
  float x, y, ax, ay, t, vx, vy, b, curTime, preTime;
  float ox, oy;

  //コンストラクタ
  PhysicalPoint() {
    preTime = millis();
    b = 0.90;  //摩擦係数
    vx = 0;  //x（初）速度
    vy = 0;  //y（初）速度
    ax = 0;  //x加速度
    ay = 0;  //y加速度
    x = 0;  //現在のx座標
    y = 0;  //現在のy座標
    ox = 0;  //ホームポジションのx座標
    oy = 0;  //ホームポジションのx座標
  }
  PhysicalPoint(float _x, float _y) {
    this();
    x = _x;
    y = _y;
    ox = x;
    oy = y;
  }
  //座標を更新する（メインスケッチのdraw()内で呼ぶ必要がある）
  void update() {
    curTime = millis();  //現在時刻をミリ秒単位で取得
    t = (curTime - preTime) * 0.001;  //前フレームの時刻から現在時刻を引いて経過時間を計算
    if (t > 0.066) t = 0.066;

    x += vx * t + 0.5 * ax * t * t;  //現在の速度、加速度と経過時間から現在位置を計算
    y += vy * t + 0.5 * ay * t * t;

    vx += ax * t;  //現在の速度を加速度から算出
    vy += ay * t;

    vx *= b;  //速度に摩擦係数を与える
    vy *= b;

    ax = 0;  //加速度を0にする
    ay = 0;

    preTime = curTime;  //次フレームのために現フレームの時刻を保存しておく。
  }
  //初期座標を設定する（ホームポジションの座標も設定される）
  void setPoint(float _x, float _y) {
    x = _x;
    y = _y;
    ox = x;
    oy = y;
  }
  //加速度を与える
  void setAcceleration(float _ax, float _ay) {
    ax += _ax;
    ay += _ay;
  }
  //角度direに向かってrの加速度を与える
  void setAccelerationTo(float r, float dire) {
    ax += r * cos(dire);
    ay += r * sin(dire);
  }
  //目的のx, y座標に向かって加速度を与える
  void setAccelerationTo(float _x, float _y, float power) {
    setAcceleration((_x-x)*power, (_y-y)*power);
  }
  //摩擦係数の変更
  void setFriction(float _b) {
    b = _b;
  }
  //現在地からx1, y1への距離を取得
  float distanceTo(float x1, float y1) {
    float dist =  sqrt((x1-x)*(x1-x) + (y1-y)*(y1-y));
    return dist;
  }
  //現在地からx1, y1への角度を取得
  float angleTo(float x1, float y1) {
    float angle = 0.0;
    if (x == x1) {
      if (y < y1)  return PI/2.0;
      if (y > y1)  return -PI/2.0;
      if (y == y1)  return 0.0;
    }
    angle = atan((y1-y)/(x1-x));
    if (x > x1)  angle -= PI;
    if (angle < 0.0)  angle += PI*2.0;
    if (angle > PI*2.0)  angle -= PI*2.0;
    return angle;
  }
  //速度、加速度を0にする
  void resetAcceleration() {
    ax = 0;
    ay = 0;
    vx = 0;
    vy = 0;
  }
}

