//葉っぱの絵のSVGデータのファイル名
String[] fName = {
  "data/tochi.svg", 
  "data/sakura.svg", 
  "data/metasequoia.svg"
};  
//葉っぱの絵のSVGオブジェクト名（illustratorでのパスグループに対応）
String[] leafNames = {
  "tochi", 
  "sakura", 
  "metasequoia"
};
//葉っぱの和名
String[] leafJNames = {
  "トチノキ", 
  "ソメイヨシノ", 
  "メタセコイア"
};
//葉っぱの説明文（内容はsetup()内で入力）
String[] description = new String[fName.length];

PShape[] leaves = new PShape[fName.length];  //葉っぱのSVGデータ
float[] x = new float[fName.length];  //葉っぱを描画するX座標
float[] y = new float[fName.length];  //葉っぱを描画するY座標
float[] w = new float[fName.length];  //葉っぱを描画する幅
float[] h = new float[fName.length];  //葉っぱを描画する高さ
float[] ix = new float[fName.length];  //葉っぱの行くべきX（アニメーション用）
float[] iy = new float[fName.length];  //葉っぱの行くべきY（アニメーション用）
float[] ow = new float[fName.length];  //オリジナルの幅
float[] oh = new float[fName.length];  //オリジナルの高さ
boolean[] isActive = new boolean[fName.length];

PShape mapSVG;  //キャンパスマップのサブレイヤーのSVGデータ
PShape treesSVG;  //樹木の位置を円プロットしたサブレイヤーのSVGデータ
PShape[] trees;  //木の位置を示す円
String[] treeNames;

PGraphics textG;

void setup() {
  size(1024, 768);
  description[0] = "山地にはえる落葉高木。高さ30m、幹の直径60cmの大木になる。小枝は暗灰色で太い。冬芽はよく粘る。葉は対生し、大きな掌状複葉で、小葉は5〜7。長いさかさ卵形で、中央のものが最も大きく長さ20〜35cm。\n［分布］北海道・本州・四国・九州\n［用途］街路樹・庭木・家具・楽器";
  description[1] = "栽培されている落葉高木。高さ7m内外になり、樹皮は暗灰色。若枝は淡黄褐色。葉は互生し、広いさかさ卵形で長さ8cm内外。先は急に細く尖り、縁には細かく鋭い重鋸歯がある。\n［分布］野生は見当らない。オオシマザクラとエドヒガンとの雑種であろうという。\n［用途］公園樹・並木・庭木";
  description[2] = "近頃、学校の庭や、公園などに記念樹としてよく植えられる落葉高木。わが国では輸入の日が浅く、大木はないが、原産地の中国では高さ35m、直径2mの大木がある。樹皮は褐色。葉はせまい披針状線形で軟かく、長さ1〜2.5cm、幅1.5〜2mm。\n［分布］原産地、中国（四川省・湖北省）→栽培。\n［用途］庭木。";

  PShape originalSVG = loadShape("data/mau_campus.svg");  //大元のSVGデータを読み込む
  mapSVG = originalSVG.getChild("Map");  //大元のSVGデータから「Map」レイヤーだけを取得
  treesSVG = originalSVG.getChild("Trees");  //大元のSVGデータから「Trees」レイヤー（木の座標を円でプロットした）だけを取得

  //Treesレイヤー内の円の座標を取得する
  int treesNum = treesSVG.getChildCount();
  trees = new PShape[treesNum];  //プロットした樹木の各点のSVGデータを入れる配列を初期化
  treeNames = new String[treesNum];  //プロットした樹木の各点のオブジェクト名を入れる配列を初期化
  for (int i = 0; i < treesNum; i++) {
    trees[i] = treesSVG.getChild(i);
    String name = trees[i].getName();
    String[] tokens = name.split("_");  //レイヤー名を「_」で分割
    treeNames[i] = "";
    if (tokens.length > 0) {
      treeNames[i] = tokens[0];
    }
  }

  //葉っぱの絵のSVGデータを取得する
  for (int i = 0; i < fName.length; i++) {
    leaves[i] = loadShape(fName[i]);
    ow[i] = leaves[i].width;  //オリジナルの幅を取得＋縮小
    oh[i] = leaves[i].height;  //オリジナルの高さを取得＋縮小
    w[i] = ow[i];
    h[i] = oh[i];
    x[i] = 0.0;
    y[i] = 0.0;
    isActive[i] = false;
  }
  textG = createGraphics(500, 500);
  PFont font = createFont("HiraKakuPro-W3", 12);  //環境に応じて書き換える
  textG.beginDraw();
  textG.textFont(font);
  textG.endDraw();
}

void draw() {
  background(0);

  //地図を描画
  mapSVG.disableStyle();  //illustratorのスタイルを無効に
  stroke(100, 100, 100); 
  noFill();
  shape(mapSVG, 0, 0, width, height);  //地図の描画

  //葉っぱを描画
  noFill();
  stroke(100, 255, 100);
  strokeJoin(ROUND);  //パスの結合部をラウンド結合に
  for (int i = 0; i < leaves.length; i++) {
    if (isActive[i] == true) {        //描画スイッチがONの場合
      x[i] += (ix[i] - x[i])/10.0;    //目的地までゆっくり近づく
      y[i] += (iy[i] - y[i])/10.0;
      w[i] += (ow[i] - w[i]) / 10.0;  //目的の大きさ（この場合は元のSVGアートボードの大きさ）にゆっくり近づく
      h[i] += (oh[i] - h[i]) / 10.0;
      shape(leaves[i], x[i] - w[i]/2, y[i] - h[i]/2, w[i], h[i]);  //葉っぱを描画

      //別キャンバス（テキストを描画済み）の描画
      image(textG, 50, 400, textG.width, textG.height);
    }
  }

  //木を描画
  for (int i = 0; i < trees.length; i++) {
    float[] params = trees[i].getParams();  //Processing.jsではサポートされていない
//    float[] params = trees[i].params;      //Processing.js用
    float cx = params[0];  //左上の点
    float cy = params[1];  //左上の点
    float ww = params[2];  //幅
    float hh = params[3];  //高さ
    //樹木にマウスオーバーで色を変える
    if (cx < mouseX && mouseX < cx + ww && cy < mouseY && mouseY < cy + hh) {
      fill(0, 255, 0);  //不透明の緑
    } else {
      fill(0, 255, 0, 100);  //半透明の緑
    }
    trees[i].disableStyle();  //illustratorのスタイルを無効に
    stroke(100, 255, 100);
    shape(trees[i]);          //木を描画

    //樹木にマウスオーバーで葉っぱの表示をON/OFFする
    if (cx < mouseX && mouseX < cx + ww && cy < mouseY && mouseY < cy + hh) {
      //前のフレームではマウスオーバーしていなかったら（このフレームで初めてマウスオーバーしたら。pmouseXとpmouseYは1つ前のフレームのマウス座標）
      if (cx > pmouseX || pmouseX > cx + ww || cy > pmouseY || pmouseY > cy + hh) {
        //その樹木のオブジェクト名と全ての葉っぱの名前を比べて、一致すればその葉っぱの表示をONする
        for (int j = 0; j < leaves.length; j++) {          
          boolean isContained = treeNames[i].contains(leafNames[j]);    //st1.contains(st2); でst1にst2が含まれるかどうかがtrue/falseで返される
          if (isContained == true) {
            isActive[j] = true;
            x[j] = cx + ww/2;  //葉っぱの出発点を樹木の円の中心に
            y[j] = cy + hh/2; 
            w[j] = 0;  //葉っぱの出発時の大きさを0にしておく
            h[j] = 0;
            ix[j] = 200;  //葉っぱの終着点を設定
            iy[j] = 225;

            //長文のテキストは重くなるので、別キャンバスに1回だけ描いてそれをとっておき、画像として描画する。
            textG.beginDraw();  //別キャンバス内への描画を開始
            textG.background(0, 0);  //一旦背景を透明色で塗りつぶす
            textG.fill(255);  //別キャンバス内の塗り色を設定
            textG.text(leafJNames[j], 0, 30);  //別キャンバス内に和名を描画
            textG.textLeading(22);  //文字の行送りを22pxに設定
            textG.text(description[j], 0, 50, 250, textG.height);  //text(st, x, y, w, h)で w, h の四角におさまるよう文字を改行してくれる。ただし日本語の場合は挙動がちょっとおかしい。
            textG.endDraw();  //別キャンバス内への描画を終了
          } else {
            isActive[j] = false;
          }
        }
      }
    }
  }
}
