String[] name = {
  "data/a1.svg", 
  "data/a2.svg", 
  "data/a3.svg", 
  "data/a4.svg", 
  "data/a5.svg", 
  "data/a6.svg", 
  "data/a7.svg", 
  "data/a8.svg"
};
PShape[] s = new PShape[name.length];
float[] x = new float[name.length];
float[] y = new float[name.length];
float[] w = new float[name.length];
float[] h = new float[name.length];
float[] ow = new float[name.length];  //オリジナルの幅
float[] oh = new float[name.length];  //オリジナルの高さ
void setup() {
  size(1024, 768);
  for (int i = 0; i < name.length; i++) {
    s[i] = loadShape(name[i]);
    ow[i] = s[i].width;  //オリジナルの幅を取得
    oh[i] = s[i].height;  //オリジナルの高さを取得
  }
}

void draw() {
  background(0);
  float curX = 50;
  for (int i = 0; i < s.length; i++) {
    curX = curX + ow[i]/2;   //自分の幅の半分を足す
    x[i] = curX;
    curX = curX + ow[i]/2 + 20;  //自分の幅の半分を足す。+20はマージン。
    y[i] = 200;
    s[i].disableStyle();  //オリジナルの色を捨ててProcessingで指定する色を使用
    if (x[i] - w[i]/2 < mouseX && mouseX < x[i] + w[i]/2 && y[i] - h[i]/2 < mouseY && mouseY < y[i] + h[i]/2) {
      w[i] += (ow[i] * 2 - w[i]) / 10.0;
      h[i] += (oh[i] * 2 - h[i]) / 10.0;
      fill(100, 255, 100);
    } else {
      w[i] += (ow[i] - w[i]) / 10.0;
      h[i] += (oh[i] - h[i]) / 10.0;
      noFill();
    }
    stroke(100, 255, 100);
    shape(s[i], x[i] - w[i]/2, y[i] - h[i]/2, w[i], h[i]);
  }
}
