PShape s[] = new PShape[20];  //SVGデータを入れるオブジェクトの配列
float x[] = new float[s.length];  //描画するx座標
float y[] = new float[s.length];  //描画するy座標
float w[] = new float[s.length];  //描画する幅
float h[] = new float[s.length];  //描画する高さ
float ax[] = new float[s.length];  //x移動量
float ay[] = new float[s.length];  //y移動量
float ow[] = new float[s.length];  //オリジナルの幅
float oh[] = new float[s.length];  //オリジナルの高さ

void setup() {
  size(1024, 768);
  for (int i = 0; i < s.length; i++) {
    s[i] = loadShape("data/insect.svg");   //同じSVGファイルを読み込む
    ow[i] = s[i].width;  //オリジナルの幅を取得
    oh[i] = s[i].height;  //オリジナルの高さを取得
    x[i] = random(0, width);  //初期のx座標を（0〜画面幅）の間でランダムで設定
    y[i] = random(0, height);  //初期のy座標を（0〜画面の高さ）の間でランダムで設定
    ax[i] = random(-5, 5);   //初期のx移動量を（-5〜5）の間でランダムで設定
    ay[i] = random(-5, 5);   //初期のy移動量を（-5〜5）の間でランダムで設定
  }
}

void draw() {
  background(0);
  for (int i = 0; i < s.length; i++) {
    //移動
    x[i] += ax[i];
    y[i] += ay[i];
    //壁で跳ね返る
    if (x[i] > width || x[i] < 0) {
      ax[i] *= -1;
    }
    if (y[i] > height || y[i] < 0) {
      ay[i] *= -1;
    }
    s[i].disableStyle();  //オリジナルの色を捨ててProcessingで指定する色を使用
    //マウスで触ったら
    if (x[i] - w[i]/2 < mouseX && mouseX < x[i] + w[i]/2 && y[i] - h[i]/2 < mouseY && mouseY < y[i] + h[i]/2) {
      w[i] += (ow[i] * 5.0 - w[i]) / 10.0;
      h[i] += (oh[i] * 5.0 - h[i]) / 10.0;
      fill(100, 255, 100);
    } else {
      w[i] += (ow[i] - w[i]) / 10.0;
      h[i] += (oh[i] - h[i]) / 10.0;
      noFill();
    }
    
    //描画
    stroke(100, 255, 100);
    shape(s[i], x[i] - w[i]/2, y[i] - h[i]/2, w[i], h[i]);
  }
}

