import processing.sound.*;  //Soundライブラリのインポート
SoundFile file;             //音声ファイルを入れる箱
boolean isPressed = false;  //マウスを押している間かどうかのフラグ
PFont font;

void setup() {
  size(1024, 768);
  file = new SoundFile(this, "data/mahiwa.wav");  //音声ファイルを読み込み
  file.loop();      //ループ再生
  //  file.play();  //一度だけ再生
  file.amp(0.001);  //音量。0〜1.0
  font = createFont("HiraginoSans-W3", 48);
  textFont(font);
  textSize(12);
}

void draw() {
  background(0);
  float x = width/2;    //パンと音量を決めるための基準点の座標
  float y = height/2;
  float angle = atan2(y - mouseY, x - mouseX);  //マウスとx, yとの角度を測る
  float distance = dist(x, y, mouseX, mouseY);  //マウスとx, yの距離を測る
  //x, yとマウスの距離が、音がなり始める半径より小さくなったら音量とパン度合いを計算する
  float r = 300;        //音がなり始める半径
  if (distance < r) {
    float volume = (r - distance) / r;  //ボリュームを、2点が近くなるに連れて大きくなるよう計算。
    float pan = cos(angle);  //パン度合い
    file.amp(volume);    //音量を設定
    file.pan(pan);       //パンを設定（-1.0〜1.0）
    //補助テキストの描画
    if (isPressed == true) {
      noStroke();
      fill(255);
      text("amp: " + volume + ", pan: " + pan, mouseX, mouseY);
    }
  } else {
    file.amp(0.001);      //音量を下げる
  }
  //補助グラフィックの描画
  if (isPressed == true) {
    noStroke();
    fill(0, 255, 255, 50);
    ellipse(x, y, r*2, r*2);
    stroke(255);
    noFill();
    line(x, y, mouseX, mouseY);
  }
}
void mousePressed() {
  isPressed = true;
}
void mouseReleased() {
  isPressed = false;
}
