//回転するテキストボックス
class TextBox {
  float cx = 0.0;  //円の中心点x
  float cy = 0.0;  //円の中心点y
  float r = 100;  //(cx, cy)を中心とした円の半径
  float angle = 0.0;  //(cx, cy)を中心とした円における、自分の角度
  float x = 0.0;   //円の中心点と、半径、角度から算出されるx座標を入れる
  float y = 0.0;   //円の中心点と、半径、角度から算出されるy座標を入れる
  String name = "回転テキスト";
  float fontSize = 12;  //フォントサイズ
  PVector[] pts = new PVector[4];  //バウンディングボックスの各頂点の座標を入れる
  boolean isHover = false;  //マウスオーバーしている状態かどうか

  TextBox() {
    for (int i = 0; i < pts.length; i++) {
      pts[i] = new PVector(0, 0);
    }
  }
  void update() {
    //中心、半径、角度からx, y座標を計算する
    x = cx + r * cos(angle);
    y = cy + r * sin(angle);
    /*
    //文字を大きくしたりする場合はコメントアウトを外す。ただしフレームレートはかなり落ちる
    if(isHover == true){
      fontSize += (24.0 - fontSize) / 10.0;
    }else{
      fontSize += (12.0 - fontSize) / 10.0;      
    }
    */
    updatePoints();    //バウンディングボックスの座標を更新する
     //マウスオーバーしていたらisHoverをtrueに変える。それ以外はfalseにする。
    if(isMouseOver() == true){
      isHover = true;
    }else{
      isHover = false;
    }
  }
  
  //テキストの描画
  void draw() {
    textAlign(CENTER, CENTER);
    textSize(int(fontSize));

    fill(255);
    noStroke();
    
    //文字の描画
    pushMatrix();    //座標変換開始
    translate(x, y);  //座標の中心点をx,yに移動する
    rotate(angle);    //座標を回転させる
    text(name, 0, 0);  //座標の中心点に文字を描く
    popMatrix();
  }

  //バウンディングボックスを描画
  void drawBoundingBox(){
    noFill();
    stroke(255, 0, 0);
    if(isHover){
      fill(255, 0, 0, 100);
    }
    beginShape();
    for (int i = 0; i < pts.length; i++) {
      vertex(pts[i].x, pts[i].y);
    }
    endShape(CLOSE);
  }
  
  //バウンディングボックスの座標を更新する
  void updatePoints() {
    textAlign(CENTER, CENTER);
    textSize(int(fontSize));
    float w = textWidth(name);
    float h = textAscent() + textDescent();
    float rr = dist(0, 0, w/2, h/2);  //テキストボックスの中心から各頂点までの距離
    float[] angs = new float[4];
    angs[0] = atan2(-h/2, -w/2);  //左上の点の角度
    angs[1] = atan2(-h/2, w/2);   //右上の点の角度
    angs[2] = atan2(h/2, w/2);    //右下の点の角度
    angs[3] = atan2(h/2, -w/2);   //左下の点の角度
    for (int i = 0; i < pts.length; i++) {
      pts[i].x = x + rr * cos(angle + angs[i]);
      pts[i].y = y + rr * sin(angle + angs[i]);
    }
  }
  
  //以下、マウスオーバーしているかどうかを答える関数（触らない）==================================================
  boolean isMouseOver() {
    //ある点（座標）が多角形の中にあるかを調べる
    boolean inside = false;
    for (int i = 0; i < pts.length; i++) {
      if (intersects(pts[i], pts[(i+1)%pts.length], mouseX, mouseY))
        inside = !inside;
    }
    return inside;
  }  
  boolean intersects(PVector a, PVector b, float theX, float theY) {
    if (a.y > b.y)
      return intersects(b, a, theX, theY);
    if (theY == a.y || theY == b.y)
      theY += 0.0001;
    if (theY > b.y || theY < a.y || theX >= max(a.x, b.x))
      return false;
    if (theX < min(a.x, b.x))
      return true;
    float red = (theY - a.y) / (float)(theX - a.x);
    float blue = (b.y - a.y) / (float)(b.x - a.x);
    return red >= blue;
  }
}
