TextBox[] t = new TextBox[72];  //テキストボックスの配列
PFont font;
void setup() {  
  size(1024, 768);
  for (int i = 0; i < t.length; i++) {
    t[i] = new TextBox();  //初期化
    t[i].cx = width/2;  //中心点を教える
    t[i].cy = height/2;
    t[i].r = 300;  //中心点からの距離を教える
    t[i].angle = PI * 2 / t.length * i;  //中心点からの回転角を教える
    t[i].name = "tの" + i + "番目";
  }
  font = createFont("YuGo-Medium", 12);
  textFont(font);
}

void draw() {
  background(0);
  for (int i = 0; i < t.length; i++) {
    t[i].update();
    t[i].angle += 0.001;  //全体を回転させる（不必要ならトル）
  }
  for (int i = 0; i < t.length; i++) {
    t[i].drawBoundingBox();  //バウンディングボックスを描画（必要であれば）
    t[i].draw();    //文字を描画
  }
  fill(255);
  textAlign(LEFT, BASELINE);
  textSize(12);
  text(frameRate, 50, 50);
}
